// Mark Sowul 2002
//All rights reserved

//Mark Sowul Per. 6

#include "deck.h"

deck::deck()
{ //set up a standard deck
	for (int suit=0; suit <4; suit++)
	{
		for (int val=2; val <=14; val++)
		{
			for (int iter=0; iter < NUMDECKS; iter++)
				myDeck.enqueue(card(suit, val));//add duplicates
		}
	}
	shuffle();
}

card deck::getCard()
{ //pick a random card and mark it as used
	if(myDeck.isEmpty())
		shuffle();
	card temp;
	myDeck.dequeue(temp);
	myDiscard.enqueue(temp);
	return temp;
}

void deck::shuffle()
{	//way too involved shuffling routine
	apqueue<card> tempQ1, tempQ2, tempQ3;
	apvector<card> tempDeck;
	card temp;
	
	cout << "Compiling queue to vector...\n";
	while (!myDeck.isEmpty())	//first we need random access so
	{							// dequeue deck into a vector
		myDeck.dequeue(temp);
		tempDeck.resize(tempDeck.length()+1);
		tempDeck[tempDeck.length()-1]=temp;
	}
		
	cout << "Cutting deck..deck has " << tempDeck.length() << " cards and " << myDiscard.length() << " discards...\n";
	if (myDiscard.length() >= 52)
		cout << "Warning!! Discards are more than single deck!";
	for (int i=0, temprand=r.RandInt(tempDeck.length()); i<r.RandInt(3,10*NUMDECKS); i++, temprand=r.RandInt(tempDeck.length()))	//do this rand # of times
	{
		//reinserting into vector for next pass
		for(int count=0; !tempQ3.isEmpty(); count++)
			tempQ3.dequeue(tempDeck[count]);
		
		
		for (int j=0; j<temprand; j++)		//split deck into 2 queues
			tempQ1.enqueue(tempDeck[j]);
		for (int k=temprand; k<tempDeck.length(); k++)
			tempQ2.enqueue(tempDeck[k]);

		while(!tempQ1.isEmpty() || !tempQ2.isEmpty())
		{		//add both queues back into deck (alternating)
			if(!tempQ2.isEmpty())
			{
				tempQ2.dequeue(temp);
				tempQ3.enqueue(temp);
			}
			if(!tempQ1.isEmpty())
			{
				tempQ1.dequeue(temp);
				tempQ3.enqueue(temp);
			}
		}
	}

	cout << "Inserting Discards...deck has " << tempQ3.length() << " cards and " << myDiscard.length() << " discards...\n";
	while(!tempQ3.isEmpty() || !myDiscard.isEmpty())
	{	//alternate insertion of discards and unused cards
		if(!tempQ3.isEmpty())
		{
			tempQ3.dequeue(temp);
			tempQ1.enqueue(temp);
		}
		if(!myDiscard.isEmpty())
		{
			myDiscard.dequeue(temp);
			tempQ1.enqueue(temp);
		}
	}

	cout << "Recompiling vector with " << tempQ1.length() << " cards...\n";
	int count=0;
	tempDeck.resize(tempQ1.length());
	while(!tempQ1.isEmpty())
	{
		tempQ1.dequeue(tempDeck[count]);
		count++;
	}

	cout << "Swapping random cards...\n";
	if (tempDeck.length())
	{
		for (int swap1=r.RandInt(tempDeck.length()), swap2=r.RandInt(tempDeck.length()), z=0; 
			z<r.RandInt(15,35*NUMDECKS); 
			z++, swap1=r.RandInt(tempDeck.length()), swap2=r.RandInt(tempDeck.length()))
		{	//swap random cards
			temp=tempDeck[swap1];
			tempDeck[swap1]=tempDeck[swap2];
			tempDeck[swap2]=temp;
		}
	}
	
	cout << "Recompiling into queue...\n";
	
	for (int x=0; x<tempDeck.length(); x++)
		myDeck.enqueue(tempDeck[x]); //back into my Queue
	cout << "Deck has: " << tempDeck.length() << " cards...\nShuffle complete...\n\n";
#ifndef _DEBUG
		cin.ignore(0, '\n');
		system("CLS");
#endif
}