// Mark Sowul 2002
//All rights reserved

//Mark Sowul Per. 6

#include "hand.h"
#include "apvector.h"

hand::hand(bool isDealer,card card1, card card2)
{//set up a default blackjack hand
	myCards.resize(2);
	myCards[0]=card1;
	myCards[1]=card2;
	amIDealer=isDealer;
}

void hand::addCard(card theCard)
{//add a card to the hand
	myCards.resize(myCards.length()+1);
	myCards[myCards.length()-1]=theCard;
}

card hand::getCard(int whichCard)
{//get a specific card
	 return myCards[whichCard];
}

apstring hand::getCardString(int whichCard)
{//gets a string representing card for row (+ split card on that row if exist)
	apstring temp;
	if (whichCard < myCards.length())
		temp+=myCards[whichCard].toString();
	temp+='\t';
	if (amISplit())
	{
		if (whichCard < mySplit.length())
			temp+=mySplit[whichCard].toString();
	}
	temp+="\t\t\t";
	return temp;
}

apstring hand::getCardStringMasked(int whichCard)
{ //for dealer to hide his cards
	switch(whichCard)
	{
	case(0):
		return myCards[whichCard].toString();
		break;
	case(1):
		return "??";
		break;
	default:
		return "";
		break;
	}
}

int hand::howManyCards()
{//simple
	return myCards.length();
}

int hand::totalValue(bool gettingSplit)
{//get total value of hand/split
	apvector<card> temp;
	if (gettingSplit)
		temp=mySplit;
	else
		temp=myCards;
	int count=0, ace=0;
	for(int i=0; i<temp.length(); i++)
	{
		if (temp[i].getValue()==11)
			ace++;
		if (temp[i].getValue()<=11)
			count+=temp[i].getValue();
		else
			count+=10;
	}
	while (count > 21 && ace)
	{
		ace--;
		count-=10;
	}
	return count;
}


void hand::split(card new1, card new2)
{//set up the split
	mySplit.resize(2);
	mySplit[0]=myCards[1];
	myCards[1]=new1;
	mySplit[1]=new2;
}

card hand::getSplitCard(int whichCard)
{//same as getCard but for split hand
	return mySplit[whichCard];
}

void hand::addSplitCard(card theCard)
{//same as addCard but for split hand
	mySplit.resize(mySplit.length()+1);
	mySplit[mySplit.length()-1]=theCard;
}

int hand::howManySplit()
{//same as howManyCards but for split
	return mySplit.length();
}

bool hand::amISplit()
{//is this hand split?
	return mySplit.length();
}
