//Mark Sowul Per. 6

#ifndef _HAND_H
#define _HAND_H

#include "card.h"
#include "apvector.h"

class hand
{
public:
	hand(bool isDealer, card, card);
			//post: a hand is setup consisting of two cards and isDealer flag set
	void addCard(card theCard);
			//post: theCard has been added to the hand
	card getCard(int whichCard);
			//post: card #whichCard has been returned
	apstring getCardString(int whichCard);
			//post: suit+value+tabs have been returned in string form
	apstring getCardStringMasked(int whichCard);
			//post: suit+value+tabs has been returned
			//		if dealer, on 2nd card returns "??" and on subsequent cards
			//		returns a null string (to hide dealer hand)
	int totalValue(bool gettingSplit);
			//post: total value of hand has been returned
	int howManyCards();
			//post: number of cards in this hand has been returned
	
	void split(card new1, card new2);
			//post: hand has been split according to rules of blackjack
	card getSplitCard(int whichCard);
			//post: split card whichCard has been returned
	void addSplitCard(card theCard);
			//post: card theCard has been added to split hand
	int howManySplit();
			//post: number of cards in split hand returned;
	bool amISplit();
			//post: returns whether this hand is split

private:	//private member variables
	apvector<card>myCards;
	apvector<card>mySplit;
	bool amIDealer;
};

#endif